#include <mkl.h>
#include <omp.h>

float ComputePi(int n) {

  int hits = 0;
#pragma omp parallel reduction(+: hits)
  {
    VSLStreamStatePtr rnStream; // Random number generator
    vslNewStream(&rnStream, VSL_BRNG_MT19937, omp_get_thread_num()); 

    float x, y, r; // Temporary variables
#pragma omp for
    for (int i = 0; i < n; i++) {
      vsRngUniform(VSL_RNG_METHOD_UNIFORM_STD, rnStream, 1, &x, 0.0f, 1.0f);
      vsRngUniform(VSL_RNG_METHOD_UNIFORM_STD, rnStream, 1, &y, 0.0f, 1.0f);
      r = x*x + y*y;
      if (r < 1.0f) 
	hits++;
    }
  }
  float pi_est = 4.0f * (float)hits / (float)n;
  return pi_est;
}
