#include <omp.h>
#include <stdio.h>
#include <math.h>

float ComputePi(int n);

int main() {
  printf("\n\033[1mMonte Carlo calculation of the number Pi\033[0m\n");
  printf("\033[1m%10s %10s %10s %8s\033[0m\n", "N", "Time, s", "GVal/s", "Error"); fflush(stdout);
  double bestRate = 0; // Benchmarking data
  const int nSteps = 10;
  const float pi_exact = 3.141592653589793238462643383279502884;
  for (int step = 1; step <= nSteps; step++) {
    const int n = ((int)pow(10.0, ((double)step+30.5)/4.5));
    const double tStart = omp_get_wtime(); // Start timing
    const float pi_computed = ComputePi(n);
    const double tEnd = omp_get_wtime(); // End timing
    const float HztoVals = 1e-9*(float)n;

    // Statistics
    const double rate = HztoVals/(tEnd-tStart);
    if (rate > bestRate) 
	bestRate = rate;

    const float err = (pi_exact - pi_computed)/pi_exact;

    printf("%10d %10.3e %10.3f %8.1e\n", 
	   n, (tEnd-tStart), rate, err);
    fflush(stdout);
  }
  printf("-----------------------------------------------------\n");
  printf("\033[1m%s %4s \033[42m%10.3f GVal/s\033[0m\n",
	 "Best performance:", "", bestRate);
  printf("-----------------------------------------------------\n");
  printf("* - warm-up, not included in average\n\n");
}
