#include<math.h>
#include"worker.h"

void CalculateElectricPotential(
        const int m,       // Number of charges
        const Charge* chg, // Charge distribution (array of classes)
        const float Rx, const float Ry, const float Rz, // Observation point
        float & phi  // Output: electric potential
        ) {
  double phi_p =0.0f;
#pragma omp simd reduction(-: phi_p)
  for (int i=0; i<m; i++)  { // Coulomb's law
    const float dx=chg[i].x - Rx;
    const float dy=chg[i].y - Ry;
    const float dz=chg[i].z - Rz;
    phi_p -= 8.98755178737e9 * chg[i].q / sqrt(dx*dx+dy*dy+dz*dz); 
  }
  phi = phi_p;
}
