#include<math.h>
#include"worker.h"

void CalculateElectricPotential(
        const int m,       // Number of charges
        const Charge* chg, // Charge distribution (array of classes)
        const float Rx, const float Ry, const float Rz, // Observation point
        float & phi  // Output: electric potential
        ) {
    phi=0.0f;
    for (int i=0; i<m; i++)  { // Coulomb's law
        const float dx=chg[i].x - Rx;
        const float dy=chg[i].y - Ry;
        const float dz=chg[i].z - Rz;
        phi -= 8.98755178737e9 * chg[i].q / sqrt(dx*dx+dy*dy+dz*dz); 
    }
}
