#include<math.h>
#include"worker.h"

void CalculateElectricPotential(
        const int m,       // Number of charges
        const Charge_Dist chg, // Charge distribution (structure of arrays)
        const float Rx, const float Ry, const float Rz, // Observation point
        float & phi  // Output: electric potential
        ) {
    float phi_p=0.0f;
#pragma omp simd reduction (-: phi_p)
    for (int i=0; i<m; i++)  {  // Coulomb's law
        const float dx=chg.x[i] - Rx;
        const float dy=chg.y[i] - Ry;
        const float dz=chg.z[i] - Rz;
        phi_p -= 8.98755178737e9f * chg.q[i] / sqrtf(dx*dx+dy*dy+dz*dz);
    }
    phi = phi_p;
}
