#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <omp.h>
#include <libzbc/zbc.h>


int main(int argc, char* argv[]) {

  if(argc < 3) {
    printf("ERROR: path [zones]\n");
    exit(1);
  }

  struct zbc_device_info info;
  struct zbc_device *dev = NULL;
  struct zbc_zone *zones = NULL;
  struct zbc_zone *iozone = NULL;
  unsigned int nr_zones;
  char *path, *file = NULL;
  unsigned int ret;

  path = argv[1];
  
  /* Open device */
  ret = zbc_open(path, O_WRONLY, &dev);
  if ( ret != 0 ) {
    exit(1);
  }

  /* Getting device info */
  ret = zbc_get_device_info(dev, &info);
  if ( ret < 0 ) {
    fprintf(stderr,
	    "zbc_get_device_info failed\n");
    exit(1);
  }
  
  /* Get zone list */
  ret = zbc_list_zones(dev, 0, ZBC_RO_ALL, &zones, &nr_zones);
  if ( ret != 0 ) {
    fprintf(stderr, "zbc_list_zones failed\n");
    ret = 1;
    exit(1);
  }

  /* Populating zone_ids[] (the list of the zones to work with) */
  const int nZones = argc-2;  
  int zone_ids[nZones]; 
  int z;
  for(z = 0; z < nZones; z++) {
    int zone_id = atoi(argv[z+2]);
    if(zone_id > 37255 || zone_id < 378) {
      printf("Invalid zone: %d   Please choose a sequential zone (id = 378 - 37255)\n", zone_id);
      exit(2);
    }
    zone_ids[z] = zone_id;
  }

  /* Resetting zones */
  int i;
  for(i=0; i < nZones; i++) {
        zbc_reset_write_pointer(dev,zbc_zone_start_lba(&zones[zone_ids[i]]));
  }

  /* Cleaning up */
  zbc_close(dev);  
}
